<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


class XenCentral_AdServer_Model_Options extends XenCentral_AdServer_Model_Abstract
{
    protected function _getOption($option)
    {
        return XenForo_Application::get('options')->{'xcas_' . $option};
    }

    /**
     * @return bool
     * Meant to be overridden by other addons that want to hide the sidebar
     */
    public function showAccountSidebar()
    {
        return true;
    }

    /**
     * @return bool
     * Meant to be overridden by other addons that want to hide My Ads link
     */
    public function showSiteZones()
    {
        return true;
    }



    public function disableStatistics()
    {
        return $this->_getOption('disable_statistics');
    }

    public function debugMode()
    {
        return $this->_getOption('debug_mode');
    }

    public function getDailyCapping()
    {
        return $this->_getOption('daily_capping');
    }

    public function getPaypalEmail()
    {
        return XenForo_Application::getOptions()->get('payPalPrimaryAccount');
    }

    public function add_in_user_popup()
    {
        return $this->_getOption('add_in_user_popup');
    }

    public function alert_sender_id()
    {
        return $this->_getOption('alert_sender_id');
    }

    public function getImpressionNotificationThreashold()
    {
        return $this->_getOption('impression_notification_threashold');
    }

    public function notify_admin_email()
    {
        return $this->_getOption('notify_admin_email');
    }

    public function notify_admin_alert()
    {
        return $this->_getOption('notify_admin_alert');
    }

    public function notify_user_email()
    {
        return $this->_getOption('notify_user_email');
    }

    public function notify_user_alert()
    {
        return $this->_getOption('notify_user_alert');
    }

    public function default_price_per_click($user_id = 0)
    {
        return $this->_getOption('default_price_per_click');
    }

    public function transaction_currency()
    {
        return $this->_getOption('transaction_currency');
    }
}